local assets=
{
	Asset("ANIM", "anim/darkmatter.zip"),
	Asset("IMAGE", "images/darkmatter.tex"),
	Asset("ATLAS", "images/darkmatter.xml"),
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    
    --inst.AnimState:SetBank("manrabbit_tail")
	inst.AnimState:SetBank("darkmatter")
    inst.AnimState:SetBuild("darkmatter")
    inst.AnimState:PlayAnimation("idle",true)
    MakeInventoryPhysics(inst)
    
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("inspectable")
    
	MakeSmallBurnable(inst)
    MakeSmallPropagator(inst)
    

	--inst:AddComponent("tradable")    
	--inst.components.tradable.goldvalue = TUNING.GOLD_VALUES.MEAT*2
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "darkmatter"
    inst.components.inventoryitem.atlasname = "images/darkmatter.xml"
    inst.components.inventoryitem:GetImage()
    inst.components.inventoryitem:GetAtlas()
    
	inst:ListenForEvent("ondropped",  function(inst)
		local ground = GetWorld()
		if ground and ground:IsRuins() then
			local pt = Point(inst.Transform:GetWorldPosition())
			local tile = ground.Map:GetTileAtPoint(pt.x, pt.y, pt.z)
			if tile and tile == 20 then
				SpawnPrefab("ancient_altar_broken").Transform:SetPosition(pt.x, 0, pt.z)
				SpawnPrefab("collapse_small").Transform:SetPosition(pt.x, 0, pt.z)
				inst:Remove()
			end
		end
	end)
	
    --inst:AddComponent("edible")
    --inst.components.edible.foodtype = "HORRIBLE"
    

    return inst
end

return Prefab( "common/inventory/darkmatter", fn, assets) 
